/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.FtpDataSocket;
import com.quantumdata.ftp.FtpFile;
import com.quantumdata.ftp.FtpInputStream;
import java.io.IOException;

public final class FtpListInputStream
extends FtpInputStream {
    public FtpListInputStream(FtpFile ftpFile) throws IOException {
        String string = null;
        if (!ftpFile.getClient().cd(ftpFile.toString())) {
            throw new IOException("File: cd command failed!\ncd " + ftpFile);
        }
        ftpFile.setAbsolutePath(ftpFile.getClient().pwd());
        this.m_data = new FtpDataSocket(ftpFile.getClient());
        switch (this.m_data.getContext().getListCommandMode()) {
            case 1: {
                string = "LIST";
                break;
            }
            case 2: {
                string = "NLST";
                break;
            }
            case 4: {
                string = "NLST -F";
                break;
            }
            case 3: {
                string = "NLST -p";
                break;
            }
            case 5: {
                string = "NLST -la";
                break;
            }
            default: {
                throw new IOException("File: Invalid List Command Mode!");
            }
        }
        this.m_stream = this.m_data.getInputStream(string, 'A');
    }
}

